/** @file   menuloadgame.h
 * @brief   Declaraction of MenuLoadGame - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_MENULOADGAME_H
#define H_WWW_MENULOADGAME_H

#include "Font.h"
#include "menupage.h"
#include "saveslot.h"
#include <vector>


namespace WeWantWar {

/** @class  MenuLoadGame
 * @brief   The LOAD GAME - menu is an instance of this class.
 * @author  Tomi Lamminsaari
 */
class MenuLoadGame : public MenuPage
{
public:
  ///
  /// Static members and methods
  /// ==========================

  /** ID of the MAINMENU - menuitem. */
  static const int BACK_TO_MAINMENU = 0;


  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Constructs the Load Game - menupage.
   */
  MenuLoadGame();
  
  /** Destructor.
   */
  virtual ~MenuLoadGame();



  ///
  /// Public methods
  /// ==============

  /** Implemented update-method. See MenuPage - class for more information.
   */
  virtual int update();
  
  /** Redraws the Load Game - menu.
   */
  virtual void redraw();



  ///
  /// Public GET-methods
  /// ==================

  /** Returns the ID of this page.
   * @return    MenuPage::LOADGAME
   */
  virtual MenuPage::PageID getPageID() const { return MenuPage::LOADGAME; }
  
  /** Returns the index of the slot where we should try to load the game.
   * @return    Index of the selected load game - slot.
   */
  int getSlotIndex() const;
  

protected:

  /** Handles the ENTER - key.
   * @return    MenuPage::NO_PAGE_CHANGE or MenuPage::PAGE_CHANGE
   */
  int checkEnterKey();



  ///
  /// Members
  /// =======

  /** The list of the saveslots */
  std::vector<SaveSlot> m_slots;

private:

  ///
  /// Private methods
  /// ===============

  MenuLoadGame(const MenuLoadGame& rO);
  MenuLoadGame& operator = (const MenuLoadGame& rO);
};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: menuloadgame.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:02+02  lamminsa
 * Initial revision
 *
 */
 
